-- 1.add user
SET @addUserId=(SELECT id FROM msg_template_config WHERE `code`='Add User');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">This is to inform you that your account has been created in <b>ACADEMIA System</b>. Below are the details:<br />
			<br />
			User Group: <strong>$templateData[&quot;USER_GROUP_NAME&quot;]</strong><br />
			<br />
			You can login into <b>ACADEMIA System</b> using following credentials.<br />
			<br />
			User Name: <strong>$templateData[&quot;CODE&quot;]</strong><br />
			Password: <strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@addUserId and `msgDeliveryModeId` = 1;


-- 2.user role
SET @addRoleId=(SELECT id FROM msg_template_config WHERE `code`='add role');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">New role <b>$templateData[&quot;ROLE_NAME&quot;]</b> added by <b>$templateData[&quot;Added_First_Name&quot;]</b> on <b>$templateData[&quot;Date_Time&quot;]</b>.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@addRoleId and `msgDeliveryModeId` = 1;

-- 3.user-Al association user template
SET @userALAssociation=(SELECT id FROM msg_template_config WHERE `code`='USER_AL_ASSOCIATION_USER');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">You have been associated with the <b>$templateData[&quot;ACADEMY_NAME&quot;], $templateData[&quot;LOCATION_NAME&quot;]</b> from <b>$templateData[&quot;FROM_DATE&quot;]</b> to <b>$templateData[&quot;TILL_DATE&quot;]</b>.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>
' WHERE `msgTemplateConfigId`=@userALAssociation and `msgDeliveryModeId` = 1;

-- 4.user-Al association admin template
SET @userALSYSAssociation=(SELECT id FROM msg_template_config WHERE `code`='USER_AL_ASSOCIATION_SYSADMIN');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello <strong> $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;],</strong> User <b>$templateData[&quot;USER_NAME&quot;]</b> has been associated with the $templateData[&quot;ACADEMY_NAME&quot;] $templateData[&quot;LOCATION_NAME&quot;] from $templateData[&quot;FROM_DATE&quot;] to <b>$templateData[&quot;TILL_DATE&quot;]</b>.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@userALSYSAssociation and `msgDeliveryModeId` = 1;

-- 5. add org structure
SET @orgUnitALId=(SELECT id FROM msg_template_config WHERE `code`='ORGANIZATION_UNIT_ADDED_AL_OWNER');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;],</strong><br />
			<br />
			This is to inform you that, a new organisation unit <b>$templateData[&quot;UNIT_NAME&quot;]</b> has been created on $templateData[&quot;CREATION_DATE&quot;] by <b>$templateData[&quot;USER_NAME&quot;]</b>, and owner name is <b>$templateData[&quot;OWNER_NAME&quot;]</b>. It is active from <b>$templateData[&quot;START_DATE&quot;]</b> to <b>$templateData[&quot;TILL_DATE&quot;]</b>.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@orgUnitALId and `msgDeliveryModeId` = 1;

-- 6. create enquiry velocity
SET @createEnqVelocityId=(SELECT id FROM msg_template_config WHERE `code`='Create Enquiry Velocity Template');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Lead ID&nbsp;<strong>$recipientData[&quot;ENQUIRY_CODE&quot;]</strong></span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;PARENT_LASTNAME&quot;]</strong></span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thank you for your interest in <strong>$recipientData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LASTNAME&quot;]</strong>&nbsp;joining our ever-growing <strong>$templateData[&quot;ACADEMY_NAME&quot;]</strong>&nbsp;community. We look forward to a long and prosperous relationship with both you and your child. In fact, we have a dedicated team of staff who are ready and waiting to answer any questions you may have.</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><strong>What&rsquo;s the next step?</strong></span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">If you require more information on our school or require any further assistance, please click here<br />
			<strong>$templateData[&quot;ACADEMY_EMAIL&quot;]</strong>&nbsp;and the school will contact you telephonically to discuss.</span></span></p>

			<p><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">If you are interested in applying for admission to our school, please click here <a href="https://stasy-uat.academiaerp.com/applynow/">https://stasy-uat.academiaerp.com/applynow/</a>&nbsp;to get the process started. Your application will be assessed and, depending on the grade (form or standard) you are enquiring for, an assessment/interview may be scheduled. If the assessment/interview has been successful, you will receive a &ldquo;Conditional Admission&rdquo; letter and on acceptance of the offer you will be able to complete the admission process by paying the relevant enrolment fee or submitting other required information as applicable.</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We can&rsquo;t wait to hear back from you!</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br />
			<strong>$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><span style="font-size:12px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></span></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@createEnqVelocityId and `msgDeliveryModeId` = 1;

-- 7. APPLICANT_LOGIN_CREDENTIAL
SET @applicationloginId=(SELECT id FROM msg_template_config WHERE `code`='Applicant Login Credential');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] &nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</strong> Your login&nbsp;credentials are as follows<br />
			<br />
			LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password :&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@applicationloginId and `msgDeliveryModeId` = 1;

-- 8. submit application velocity

SET @submitAppId=(SELECT id FROM msg_template_config WHERE `code`='Submit Application Template');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Application ID&nbsp;$recipientData[&quot;APPLICATION_CODE&quot;]</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;PARENT_PRINT_NAME&quot;]</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thank you for your interest in applying and submitting your application for $templateData[&quot;ACADEMY_NAME_LOCATION&quot;]. We have received your application fee and will now proceed with your application.</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Your application will now be assessed by the school and, depending on the grade (form or standard)&nbsp;for which you are applying, there may be an additional assessment/interview. Should this be required, we will contact you&nbsp;telephonically to arrange a suitable time and date and the details will be emailed to you.&nbsp;</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">To access your &ldquo;Application Portal&rdquo;, please use the following login details to monitor your application:</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">URL: <strong><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><a href="http://stasy-uat.academiaerp.com">stasy-uat.academiaerp.com</a></span></span></strong></p>
			Username:&nbsp;$templateData[&quot;LOGIN_ID&quot;]<br />
			Password:&nbsp;$templateData[&quot;PASSWORD&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please take the time to login and ensure the following Information is completed:</span></span></p>

			<ul>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Address information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Contact information of related Parent or Guardians;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Fee payer information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Education history;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Medical information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Any pending documentation;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Any additional student Information.</span></span></li>
			</ul>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries please contact $templateData[&quot;ACADEMY_EMAILID&quot;].</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br />
			$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>

			<p>&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@submitAppId and `msgDeliveryModeId` = 1;


-- 9. Forget password
SET @forgetPassId=(SELECT id FROM msg_template_config WHERE `code`='FORGET_PASSWORD');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your new credentials are as below:<br />
			<br />
			User Name: <strong>$templateData[&quot;CODE&quot;]</strong><br />
			Password: <strong>$templateData[&quot;PASSWORD&quot;]</strong><br />
			&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@forgetPassId and `msgDeliveryModeId` = 1;

-- Student Forget Password
SET @stuForgetPassId=(SELECT id FROM msg_template_config WHERE `code`='Student Forget Password Template');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your new Login credentials are as follows</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Password:&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@stuForgetPassId and `msgDeliveryModeId` = 1;



-- 10 RESET_PASSWORD
SET @resetPassId=(SELECT id FROM msg_template_config WHERE `code`='Reset password Template' and `sysMsgEventId`=69);
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]</strong>&nbsp;<strong>$recipientData[&quot;LAST_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-family: sans-serif, Arial, Helvetica; font-size: 12px; background-color: rgb(240, 240, 240);">Your password has been reset with following credential&nbsp;</span><br />
			<br />
			Login ID:&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password: <strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@resetPassId and `msgDeliveryModeId` = 1;

-- APPLICANT_RESET_PASSWORD
SET @appResetPassId=(SELECT id FROM msg_template_config WHERE `code`='Reset password Template' and `sysMsgEventId`=68);
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]</strong>&nbsp;<strong>$recipientData[&quot;LAST_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your Password has been reset with following credential&nbsp;<br />
			<br />
			Login ID:&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password: <strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@appResetPassId and `msgDeliveryModeId` = 1;

-- Parent Reset Password

SET @parentResetPassId=(SELECT id FROM msg_template_config WHERE `code`='Parent Reset Password');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-heigbackgroundht:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your Password has been reset with following&nbsp;</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">LoginId :&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Password :&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@parentResetPassId and `msgDeliveryModeId` = 1;



-- 11 add external user velocity
SET @addExternalUser=(SELECT id FROM msg_template_config WHERE `code`='Add External User Velocity');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Application ID&nbsp;$recipientData[&quot;APPLICATION_CODE&quot;]</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;PARENT_PRINT_NAME&quot;]</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thank you for your interest in applying and submitting your application for $templateData[&quot;ACADEMY_NAME_LOCATION&quot;]. We have received your application fee and will now proceed with your application.</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Your application will now be assessed by the school and, depending on the grade (form or standard) for which you are applying, there may be an additional assessment/interview. Should this be required, we will contact you&nbsp;telephonically to arrange a suitable time and date and the details will be emailed to you.&nbsp;To access your &ldquo;Application Portal&rdquo;, please use the following login details to monitor your application:</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">URL:&nbsp;<a href="https://stasy-uat.academiaerp.com/">https://stasy-uat.academiaerp.com/</a></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Username:&nbsp;$templateData[&quot;LOGIN_ID&quot;]<br />
			Password:&nbsp;$templateData[&quot;PASSWORD&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please take the time to login and ensure the following Information is completed:</span></span></p>

			<ul>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Address information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Contact information of related Parent or Guardians;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Fee payer information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Education history;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Medical information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Any pending documentation;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Any additional student Information.</span></span></li>
			</ul>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries please contact $templateData[&quot;ACADEMY_EMAILID&quot;].</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br />
			$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</span></span></p>

			<p>&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@addExternalUser and `msgDeliveryModeId` = 1;

-- 12 Enquiry Followup Reminder
SET @enqFollowupReminder=(SELECT id FROM msg_template_config WHERE `code`='Enquiry Followup Reminder Template');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Follow-up to Enquiry No.&nbsp;$recipientData[&quot;ENQUIRY_NO&quot;] is due today.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@enqFollowupReminder and `msgDeliveryModeId` = 1;

-- 13 Approve Application
SET @approveApplicationID=(SELECT id FROM msg_template_config WHERE `code`='Approve Application Template');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your application with no. <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong> has been approved.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@approveApplicationID and `msgDeliveryModeId` = 1;


-- 14 Assessment Selection Velocity (Offer letter)
SET @assesmentSelectionVelocity=(SELECT id FROM msg_template_config WHERE `code`='Assessment Selection Velocity');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$templateData[&quot;APPLICATION_CODE&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear $templateData[&quot;PARENT_PRINT_NAME&quot;],</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Congratulations!</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We would like to officially congratulate $templateData[&quot;APPLICANT_PRINT_NAME&quot;]&nbsp;on the successful completion of the required assessment.we look forward to welcoming $templateData[&quot;APPLICANT_PRINT_NAME&quot;]&nbsp; in the $templateData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;]&nbsp;family.</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please find attached the &quot;Complete Admission&quot; letter and on acceptance of the offer you will be able to complete the admission process by paying the relevant enrolment fee or submitting other required information as applicable.In order to finalise the admission process - please proceed to pay the required Enrolment Fee of $templateData[&quot;ENROLLMENT_FEE&quot;].</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries please contact -&nbsp;$templateData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$templateData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@assesmentSelectionVelocity and `msgDeliveryModeId` = 1;


-- 15 Application Rejection Velocity

SET @appRejectionId=(SELECT id FROM msg_template_config WHERE `code`='Application Rejection Velocity');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-family:arial,helvetica,sans-serif;"><span style="font-size:12px;">$templateData[&quot;APPLICATION_CODE&quot;]</span></span></p>

			<p><span style="font-family:arial,helvetica,sans-serif;"><span style="font-size:12px;">Dear&nbsp;$templateData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$templateData[&quot;PARENT_LASTNAME&quot;],</span></span></p>

			<p><span style="font-family:arial,helvetica,sans-serif;"><span style="font-size:12px;">Thank you for your interest in applying to $templateData[&quot;Academy_Name&quot;]&nbsp;for the year commencing $templateData[&quot;INTAKE_YEAR&quot;]. We regret to inform you that $templateData[&quot;STUDENT_FIRSTNAME&quot;] &rsquo;s application has not been successful.</span></span></p>

			<p><span style="font-family:arial,helvetica,sans-serif;"><span style="font-size:12px;">Please refer to the letter attached for further details in this regard. Should you have any queries please contact the Principal who will be able to assist you.</span></span></p>

			<p><span style="font-family:arial,helvetica,sans-serif;"><span style="font-size:12px;">Kind regards,</span></span></p>

			<p><span style="font-family:arial,helvetica,sans-serif;"><span style="font-size:12px;">$templateData[&quot;Academy_Name&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></span></span></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@appRejectionId and `msgDeliveryModeId` = 1;

-- 16 Complete Admission Velocity

SET @completeAdmissionId=(SELECT id FROM msg_template_config WHERE `code`='Complete Admission Velocity');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p>$templateData[&quot;APPLICATION_CODE&quot;]</p>

			<p>Dear&nbsp;$templateData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$templateData[&quot;PARENT_LASTNAME&quot;]</p>

			<p>Thank you! We have received your Enrolment Fee and would like to confirm that $templateData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$templateData[&quot;STUDENT_LASTNAME&quot;]&nbsp;is now officially enrolled at $templateData[&quot;Academy_Name&quot;]&nbsp;for $templateData[&quot;PROGRAM_NAME&quot;]&nbsp;commencing in $templateData[&quot;INTAKE_YEAR&quot;]&nbsp;. Please find attached a &ldquo;Complete Admissions Letter&rdquo; outlining the details in this regard.</p>

			<p><br />
			Please use the following login details to access your Student Portal:<br />
			URL &ndash;&nbsp;<a href="https://stasy-uat.academiaerp.com">https://stasy-uat.academiaerp.com</a><br />
			Username &ndash;&nbsp;$templateData[&quot;STUDENT_ID&quot;]<br />
			Password &ndash;&nbsp;$templateData[&quot;PASSWORD&quot;]</p>

			<p><br />
			We look forward to the exciting journey ahead!</p>

			<p><br />
			Should you have any queries please contact $templateData[&quot;Academy_Name&quot;] - $templateData[&quot;ACADEMY_EMAIL&quot;].</p>

			<p><br />
			Kind regards,<br />
			$templateData[&quot;Academy_Name&quot;]</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@completeAdmissionId and `msgDeliveryModeId` = 1;

-- 17 Provisional Admission Conditional Document
SET @assesmentCompleteId=(SELECT id FROM msg_template_config WHERE `code`='Assessment Completed Successfully But with Condition Doc');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$templateData[&quot;APPLICATION_CODE&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$templateData[&quot;PARENT_PRINT_NAME&quot;],</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Congratulations!</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We would like to officially congratulate&nbsp;$templateData[&quot;APPLICANT_PRINT_NAME&quot;] on the completion of the required assessment.Please find attached the Conditional Admission Letter outlining the details of your conditional admission.We have accepted&nbsp;$templateData[&quot;APPLICANT_PRINT_NAME&quot;] based on conditions that are clearly outlined in your letter.If you wish to discuss these condtions,Please contact the Principal.</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We look forward to welcoming&nbsp;$templateData[&quot;APPLICANT_PRINT_NAME&quot;] in the&nbsp;$templateData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;] family.In order to finalise the admission process - Please proceed to pay the required Enrollment Fee of&nbsp;$templateData[&quot;ENROLLMENT_FEE&quot;].</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">To access your <a href="http://velocity-test.academiaerp.com/">Applicant Portal</a> Please use your login details to monitor your application.</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries please contact&nbsp;$templateData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;].</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind Regards</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$templateData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@assesmentCompleteId and `msgDeliveryModeId` = 1;

-- 18 Application Rejection Post Assessment Velocity

SET @applicationRejectPostId=(SELECT id FROM msg_template_config WHERE `code`='Application Rejection Post Assessment Velocity');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$templateData[&quot;APPLICATION_CODE&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$templateData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$templateData[&quot;PARENT_LASTNAME&quot;]</span></span></p>

			<p><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We regret to inform you that <strong>$templateData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$templateData[&quot;STUDENT_LASTNAME&quot;]</strong>&nbsp;was unsuccessful in the completion of the required admission assessment.</span></span></p>

			<p><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please refer to the letter attached for further details in this regard. Should you have any queries in this regard, please contact the Principal of $templateData[&quot;Academy_Name&quot;] .</span></span></p>

			<p><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We wish <strong>$templateData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$templateData[&quot;STUDENT_LASTNAME&quot;]</strong>&nbsp;all the best with his school career.</span></span></p>

			<p><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries please contact $templateData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;].</span></span></p>

			<p><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,</span></span></p>

			<p><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><strong>$templateData[&quot;Academy_Name&quot;]</strong></span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@applicationRejectPostId and `msgDeliveryModeId` = 1;


-- 19 Provisional Admission Conditional Requirement

SET @applicationCompleteConditionId=(SELECT id FROM msg_template_config WHERE `code`='Assessment Completed Successfully But with Condition Req');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$templateData[&quot;APPLICATION_CODE&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$templateData[&quot;PARENT_PRINT_NAME&quot;],</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Congratulations!</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We would like to officially congratulate&nbsp;$templateData[&quot;APPLICANT_PRINT_NAME&quot;] on the completion of the required assessment.Please find attached the &quot;Conditional Admission Letter&quot; outlining the details of your conditional admission.We have accepted&nbsp;$templateData[&quot;APPLICANT_PRINT_NAME&quot;] based on conditions that are clearly outlined in your letter.If you wish to discuss these conditions,Please contact to the Principal.</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We look forward to welcoming&nbsp;$templateData[&quot;APPLICANT_PRINT_NAME&quot;] in the $templateData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;] family.In order to finalise the admission process - please proceed to pay the required Enrolment Fee of&nbsp;&nbsp;$templateData[&quot;ENROLLMENT_FEE&quot;].</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">To access your &quot;Application Portal&quot;,please use your login details to monitor your application.</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Should you have any queries please contact&nbsp;$templateData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;].</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind Regards&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">$templateData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;]</span></span></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img src="http://academiaerp.com/images/velocityemailerlogo/logo.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@enqFollowUpId and `msgDeliveryModeId` = 1;

-- 21 Offer Letter Doc update







